/*
 * Decompiled with CFR 0.152.
 */
package cn.es.eni.communications;

import cn.es.eni.Args;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;

public class JMSHandle {
    private Connection connection = null;
    private Session session = null;
    private Destination destination = null;

    public JMSHandle(String jms_queue) throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(Args.MQ_SERVER_URL);
        this.connection = connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.destination = this.session.createQueue(jms_queue);
    }

    public MessageProducer getProducer() throws Exception {
        return this.session.createProducer(this.destination);
    }

    public MessageConsumer getConsumer() throws Exception {
        return this.session.createConsumer(this.destination);
    }

    public TextMessage getTextMessage(String textMessage) throws Exception {
        return this.session.createTextMessage(textMessage);
    }

    public void sendTextMessageForProducer(String textMessage) throws Exception {
        this.getProducer().send((Message)this.getTextMessage(textMessage));
    }

    public void startListenerPrintOnConsoleForConsumer() throws Exception {
        this.getConsumer().setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                TextMessage textMessage = (TextMessage)message;
                try {
                    textMessage.getText();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

