/*
 * Decompiled with CFR 0.152.
 */
package cn.es.eni.tools;

import cn.es.eni.api_service.entity.IPRegion;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;

public class IPTools {
    public static boolean is_ipv4(String ip) {
        String regex = "^((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$";
        return ip.matches(regex);
    }

    public static String get_ip_address(HttpServletRequest request) {
        String ip_address;
        try {
            ip_address = request.getHeader("x-forwarded-for");
            if (ip_address == null || ip_address.isEmpty() || "unknown".equalsIgnoreCase(ip_address)) {
                ip_address = request.getHeader("Proxy-Client-IP");
            }
            if (ip_address == null || ip_address.isEmpty() || "unknown".equalsIgnoreCase(ip_address)) {
                ip_address = request.getHeader("WL-Proxy-Client-IP");
            }
            if ((ip_address == null || ip_address.isEmpty() || "unknown".equalsIgnoreCase(ip_address)) && (ip_address = request.getRemoteAddr()).equals("127.0.0.1")) {
                ip_address = InetAddress.getLocalHost().getHostAddress();
            }
            if (ip_address != null && ip_address.length() > 15 && ip_address.indexOf(",") > 0) {
                ip_address = ip_address.substring(0, ip_address.indexOf(","));
            }
        }
        catch (Exception ignore) {
            ip_address = null;
        }
        return ip_address;
    }

    public static String get_ip_region(IPRegion region) {
        if (region == null) {
            return null;
        }
        if ("\u5185\u7f51IP".equals(region.getCity())) {
            return region.getCity();
        }
        if ("\u4e2d\u56fd".equals(region.getCountry())) {
            return String.format("%s/%s\uff08%s\uff09", region.getProvince(), region.getCity(), region.getIsp());
        }
        return "\u6d77\u5916IP";
    }
}

